
#------------------------------------------------------------
rm(list = ls())
library(limma)
library(ggpubr)
library(pRRophetic)
library(ggplot2)
set.seed(123)
setwd("D:\\metabolism\\LGG\\10.drugsens\\pRRophetic")

rt = read.table("TCGA.TPM_log.txt",header = T,sep = "\t",row.names = 1)
data=rt
library(tidyverse)


group=read.table("metabolismcluster.txt",header = T,sep = "\t")
group=dplyr::select(group,id,cluster)
group$id=str_replace_all(group$id,"-",".")
colnames(data)=substr(colnames(data),1,12)
aaa=intersect(group$id,colnames(data))
data=data[,aaa]
data=as.matrix(data)
colnames(group)[2]="cluster"
rownames(group)=group$id
drugname <- c("Temozolomide")

for (i in 1:1) {
  drug=drugname[[i]]
  senstivity=pRRopheticPredict(data, drug, selection=1, dataset = "cgp2016")
  senstivity=senstivity[senstivity!="NaN"]
  write.table(senstivity, paste0(drug, ".senstivity.txt"), sep="\t", row.names = TRUE, col.names = TRUE, quote = FALSE)
  sameSample=intersect(row.names(group), names(senstivity))
  cluster=group[sameSample, "cluster",drop=F]
  senstivity=senstivity[sameSample]
  rt=cbind(cluster, senstivity)
  rt$cluster=factor(rt$cluster, levels=c("C1", "C2"))
  type=levels(factor(rt[,"cluster"]))
  comp=combn(type, 2)
  my_comparisons=list()
  for(i in 1:ncol(comp)){my_comparisons[[i]]<-comp[,i]}
  boxplot=ggboxplot(rt, x="cluster", y="senstivity", fill="cluster",bxp.errorbar=T,
                    xlab="",
                    ylab=paste0(drug, " predicted IC50"),
                    legend.title="metabolismcluster",
                    palette =c("#435E97", "#E7C169")
  )+ 
    stat_compare_means(comparisons=my_comparisons)
  pdf(file=paste0(drug, ".pdf"), width=5, height=4.5)
  print(boxplot)
  dev.off()
}
